# 父子组件通讯

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>

**父传子**<br>

- 在子组件中定义props属性 值为数组类似于data 但data中的数据来自本身 而props中的数据来自父组件
- 子组件使用模板中使用props中的属性和data中的用法相同
- 父组件通过props传值给子组件
<br/>![在这里插入图片描述](https://img-blog.csdnimg.cn/2020040312014626.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0pIWExf,size_16,color_FFFFFF,t_70)
<br/>
输出结果为：
<br/>![在这里插入图片描述](https://img-blog.csdnimg.cn/20200403120217164.png)
<br/>
说明：
1. 创建Vue实例 data中的数据msg为一个数组
2. 创建组件 在整个项目中 2组件相对就是1的子组件 
3. 通过3方式前者msg为props值中的数据 后者msg为newVue中data中的数据
4. 最后正是props中的属性也有data中的使用方法 将数据进行遍历在页面中

注意：props负责获取父组件的传递过来的，props中的值是只读的，不允许修改 

**子传父**<br>

- 父组件使用子组件时 在其中定义一个自定义事件 并且绑定父组件中的一个自定义函数 当事件被调用时执行自定义函数
- 子组件通过this$emit执行自定义事件
<br/>![在这里插入图片描述](https://img-blog.csdnimg.cn/20200403121933688.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0pIWExf,size_16,color_FFFFFF,t_70)
<br/>
最终输出结果为3
1. 在子组件中定义一个点击事件 触发时执行子组件中的dian函数 并且将参数传入函数中
2. 在上面的函数中通过this.$emit（‘事件名称’，参数）调用3中的a自定义事件并且将参数传过去
3. 当a事件被触发时 会执行4中的aaa自定义函数 同时获取参数 最终实现子组件向父组件传数据

**实例改造**<br>
根据父子组件之间的数据传递实现产品列表的组件化开发
<br/>![在这里插入图片描述](https://img-blog.csdnimg.cn/2020040312280456.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0pIWExf,size_16,color_FFFFFF,t_70)
<br/>
**代码如下**

```
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <style>
        div {
            width: 1000px;
            margin: 100px auto;
            text-align: center;
        }

        table {
            width: 900px;
            margin: 50px auto;
            border-collapse: collapse;
        }

        table,
        th,
        td {
            border: 1px solid rgb(218, 124, 17);
        }

        .color {
            background-color: rgb(26, 172, 152);
        }
    </style>
</head>

<body>
    <div id="app">
        <atitle @tian="tian" :aatitle="aupda" @cha="cha"></atitle>
        <acontent :content="newcontent" @del="del" @upda="upda"></acontent>
    </div>
    <script src="./node_modules/vue/dist/vue.js"></script>
    <script>
        Vue.component('atitle', {
            props: ['aatitle'],
            data() {
                return {
                    keyword: ''
                }
            },
            template: `<div>
                型号 <input type="text" v-model=aatitle.name>
                价格 <input type="text" v-model=aatitle.may @keyup.enter="tian">
                <button @click="tian">录入</button><br>
                <input type="text" v-model="keyword">
            </div>`,
            methods: {
                tian() {
                    this.$emit('tian', this.aatitle.name, this.aatitle.may)
                    this.aatitle.name = ''
                    this.aatitle.may = ''
                }
            },
            watch: {
                keyword: {
                    handler(newvalue) {
                        this.$emit('cha', newvalue)
                    },
                    immediate: true
                }
            }
        })
        Vue.component('acontent', {
            props: ['content'],
            template: `<table>
                    <tr>
                        <th>编号</th>
                        <th>机型</th>
                        <th>价格</th>
                        <th>时间</th>
                        <th>操作</th>
                    </tr>
                    <tr v-show="this.content.length==0">
                        <td colspan="5">没有任何发布任何产品</td>
                    </tr>
                    <tr v-for="(item,index) in content">
                        <td>{{item.id}}</td>
                        <td>{{item.name}}</td>
                        <td>{{item.may}}</td>
                        <td>{{item.time}}</td>
                        <td>
                            <a href="#"" @click.prevent="del(item.id)">删除</a>
                            <a href="#"" @click.prevent='upda(item.id)'>编辑</a>
                        </td>
                    </tr>
                </table>`,
            methods: {
                del(id) {
                    this.$emit('del', id)
                },
                upda(id) {
                    this.$emit('upda', id)
                }
            }
        })
        const app = new Vue({
            el: '#app',
            data: {
                newcontent: [],
                aupda: {},
                isup: false,
                upid: '',
                content: [{
                        id: 1,
                        name: '华为',
                        may: 5000,
                        time: Date.now()
                    },
                    {
                        id: 2,
                        name: '小米',
                        may: 6000,
                        time: Date.now()
                    },
                    {
                        id: 3,
                        name: '苹果',
                        may: 4500,
                        time: Date.now()
                    },
                    {
                        id: 4,
                        name: '1+',
                        may: 3000,
                        time: Date.now()
                    },
                    {
                        id: 5,
                        name: 'oppo',
                        may: 2000,
                        time: Date.now()
                    },
                    {
                        id: 6,
                        name: '1+2',
                        may: 8000,
                        time: Date.now()
                    },
                    {
                        id: 7,
                        name: '1+3',
                        may: 12000,
                        time: Date.now()
                    }
                ]
            },
            methods: {
                del(id) {
                    let index = this.content.findIndex(item => {
                        return item.id == id
                    })
                    this.content.splice(index, 1)
                    this.newcontent.splice(index, 1)
                },
                tian(name, may) {
                    if (this.isup) {
                        let a = this.content.find(item => {
                            return item.id == this.upid
                        })
                        a.name = name
                        a.may = may
                    } else {
                        let id = this.content.length - 1 < 0 ? 1 : this.content[this.content.length - 1].id + 1
                        let content = {
                            id: id,
                            name: name,
                            may: may,
                            time: Date.now()
                        }
                        this.content.push(content)
                        this.newcontent.push(content)
                    }
                },
                cha(value) {
                    this.newcontent = this.content.filter(item => {
                        return item.name.includes(value)
                    })
                },
                upda(id) {
                    let a = this.content.find(item => {
                        return item.id == id
                    })
                    this.aupda = {
                        name: a.name,
                        may: a.may
                    }
                    this.isup = true
                    this.upid = id
                }
            }
        })
    </script>
</body>

</html>
```
<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>




通过上面的案例，下列说法不正确的是？<br/><br/>

## 答案

父组件向子组件通讯只能使用 props 一种方法

## 选项

### A

子组件向父组件传参逻辑是通过$emit调用父组件的自定义方法的时候进行传参

### B

props负责获取父组件的传递过来的，props中的值是只读的，不允许修改 

### C

props负责获取父组件的传递过来的值也可以通过插值表达式展示在页面中
