# v-model

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>

 v-model 指令我们大家很熟悉了吧，该指令可以在表单 input、textarea 及 select 元素上创建双向数据绑定。它会根据控件类型自动选取正确的方法来更新元素。尽管有些神奇，但 v-model 本质上不过是语法糖。它负责监听用户的输入事件以更新数据，并对一些极端场景进行一些特殊处理。
v-model 会忽略所有表单元素的 value、checked、selected attribute 的初始值而总是将 Vue 实例的数据作为数据来源。你应该通过 JavaScript 在组件的 data 选项中声明初始值。

**文本框**
下面代码中p标签的值会根据上方文本框输入的值的改变而改变。

```html
<input v-model="message" placeholder="edit me">
<p>Message is: {{ message }}</p>
```
**复选框**

```html
<input type="checkbox" id="checkbox" v-model="checked">
<label for="checkbox">{{ checked }}</label>
```
多个复选框

```html
<input type="checkbox" id="jack" value="Jack" v-model="checkedNames">
<label for="jack">Jack</label>
<input type="checkbox" id="john" value="John" v-model="checkedNames">
<label for="john">John</label>
<input type="checkbox" id="mike" value="Mike" v-model="checkedNames">
<label for="mike">Mike</label>
<br>
<span>Checked names: {{ checkedNames }}</span>
```
**选择框**

```html
<div id="example-5">
  <select v-model="selected">
    <option disabled value="">请选择</option>
    <option>A</option>
    <option>B</option>
    <option>C</option>
  </select>
  <span>Selected: {{ selected }}</span>
</div>
```
上面只是为大家举了几个小案例，当然我们v-model绑定的值一定是我们在data中定义好的！

<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>


下列关于 v-model 的说法，哪项是不正确的？<br/><br/>

## 答案

v-model 是内置指令，不能用在自定义组件上

## 选项

### A

v-model 能实现双向绑定

### B

v-model 本质上是语法糖，它负责监听用户的输入事件以更新数据

### C

对 input 使用 v-model，实际上是指定其 :value 和 @input
