# S表达式

如前文所述，所有的Scheme程序都是由`( )`括起来的内容构成。不仅如此，括号中的内容还遵循，操作符，操作数，操作数，操作数的顺序。

什么是操作符呢？ 比如我们常见的数学式子 `1 + 2` 中的“+”便是操作符。引申开来，求平方也是一个操作符，或者数学中的一个函数`f(x)`也是一个操作符。

1 和 2 就是这个式子的操作数。

`f(x)=x^2`

比如这个式子表示`f(x)`的操作返回操作数的平方。

也许你已经知道在计算机语言中，我们称`f(x)`这种式子为lambda表达式。

***绝大部分Scheme程序是由这样的表达式组成的：它接受操作数，返回一个结果。***

由`(操作符 操作数 操作数 ...)`这样的顺序表示的结构便称为S表达式。

注意这里的三个`...`，这表示操作数是任意个数的。

> `...`的写法是真实存在于Scheme程序中的，它表示其左边的结构可以是无穷个或者可以无限扩展。

这便是S表达式的优点之一。

比如你需要计算 `1+2+3+4+5`，在Scheme程序中你只需要使用一个`+`:

`(+ 1 2 3 4 5)`

> Scheme语言中相当的内置操作符是接受无穷个操作数的，如+ - * /

S表达式的第二个优点，也是最重要的一个，便是这个结构很容易表达为以操作符为节点的树状结构：

比如

`(* (+ 1 2) (- 3 4))`这个Scheme程序，它具有一个根节点`*`,根节点的叶子是两个`()`。

而这两个括号分别是`+`和`-`节点，叶子分别是`1 2`和`3 4`。

```scheme
(* 
   (+ 1 2) 
   (- 3 4))
```

在计算中，我们发现必须等待根节点`*`的两个叶子分别得到值，才能进行`*`运算。

如此我们便触及到Scheme程序的另一个核心规律，总是对最尖端的叶子先求值，依次递归，直到最后一个根节点。

在Scheme中我们有一个专门的术语来对这个过程进行描述：

`+ - * /`和数字等称为一个原子`atom`。

而括号包裹的部分则不是一个原子。

当一个操作符遇到它的操作数不是原子时，它优先对操作数位置的S表达式进行求值。

再看这个括号,虽然Scheme程序是将括号放在操作符的外侧，如`(func)`, 但是它的作用和C语言或者JavaScript表达式`func()`的括号是一样的：运行。

综上，Scheme程序的运行规则可以一句话概括：从内向外运行包裹的括号，直至没有括号。

> 前文述绝大多数Scheme程序接受操作数并返回一个结果，但剩下的却不同，他们可能改变外部的环境变量。在惯例中，我们使用`!`后缀来标记这种后果。如`set!`。