# Rust 函数的生命周期(I)

选出以下Rust代码中，生命周期错误的选项

## 答案

```rust
// compile error!
// where am I come from?
fn process_objs(x:&Obejct, y:&Object):&Object{ 
  if(x.is_ok()){
    &x
  }else{
    &y
  }
}
```

## 选项

### 如果这个借用本来就是从外部传入的，那当然可以返回，函数结束后这个对象还是有效的

```rust
// I am borrowed from caller
// return borrow to the caller is safe
fn process_obj(obj:&Object):&Object{
  &obj
}
```

### 显式添加生命周期标记

```rust
// I am come from 'a lifetime, NOT 'b
fn process_objs<'a,'b>(x: &'a Obejct, y:&'b Object):&'a Object{ 
  &x
}
```

### 显式添加生命周期标记，解决歧义

```rust
// I am come from 'a lifetime, x,y,and result are all 'a lifetime
fn process_objs<'a>(x: &'a Obejct, y:&'a Object):&'a Object{ 
  if(x.is_ok()){
    &x
  }else{
    &y
  }
}
```
