# 集成测试 

在 Rust，集成测试是位于你的库外面的，一般会专门建立一个 tests 目录, 用于测试和确保当别人从外部调用你的库时工作正常。测试代码对库的使用与别人调用你的库时的用法一样，所以集成测试时只能调用库的对外暴露的函数。

集成测试只对库 crate 进行测试，不能对二进制 crate 测试。也就是说，一般是对 src/lib.rs 内的对外函数进行测试，而不会对 src/main.rs 里面的函数进行集成测试。

一般的做法是，将所有的功能性函数都写在库 (lib.rs 及关联模块) 里面，而在 main.rs 只进行简略的引入及使用。这样可以使用集成测试覆盖所有的可对外的函数。

Rust 会对 tests 目录里面的每一个文件当作单独的 crate 来编译, 这在用多线程处理时能加速测试进程。

以下命令中，*不会* 运行集成测试的是：

## 答案  

B

## 选项

### 运行所有测试 

A

```rust
cargo test
```

### 只运行单元测试

B

```rust
cargo test --lib
```

### 只运行集成测试

C

```rust
cargo test --test integration
```

### 仅运行集成测试，单线程

D

```rust
cargo test --test integration -- --test-threads=1
```

