# 文档测试 

据 Rust API 指南中的说明，Rust 的文档测试功能，主要的目的是作为练习函数使用的样例代码。同时也便于在代码更新后确保文档中测试代码正常运行。

考虑到看文档的人常会直接复制文档中的样例代码去运行，文档测试的代码要写得完善。

对写在文档中的代码片断， Rust 会隐式地在其中添加 `fn main()` 和 `extern crate <cratename>` 使之能正常编译。如测试样例的 main 函数返回的不是默认的单元类型，就需要明确的写出来完整的函数签名。

当文档测试中的代码比较长，不便于显示代码的功能，可以在文档中将部分代码隐藏，就是以 # 号加空格开头，这样可使显示出来的有功能性的代码片断更简洁。但隐藏的代码仍然会在运行测试的时候被编译。


下面的文档测试中，能正确运行的是：

## 答案 

A

```rust
/// 在文档测试中使用隐藏的 `try_main`。
///
/// ```
/// # // 被隐藏的行以 `#` 开始
/// # fn try_main() -> Result<(), String> { 
/// let res = try::try_div(10, 2)?;
/// # Ok(()) // 从 try_main 返回
/// # }
/// # fn main() { // 开始主函数
/// #    try_main().unwrap(); // 调用并展开 try_main，这样出错时测试会 panic
/// # }
pub fn try_div(a: i32, b: i32) -> Result<i32, String> {
    if b == 0 {
        Err(String::from("Divide-by-zero"))
    } else {
        Ok(a / b)
    }
}

```

## 选项

###

B

```rust
/// # fn main() {
/// let res = try::try_div(10, 2)?;
/// # Ok(())
/// # }
pub fn try_div(a: i32, b: i32) -> Result<i32, String> {
    if b == 0 {
        Err(String::from("Divide-by-zero"))
    } else {
        Ok(a / b)
    }
}

```


###

C

```rust
/// fn main() {
///     let res = try::try_div(10, 2)?;
///     Ok(())
/// }
pub fn try_div(a: i32, b: i32) -> Result<i32, String> {
    if b == 0 {
        Err(String::from("Divide-by-zero"))
    } else {
        Ok(a / b)
    }
}

```

###

D


```rust
/// 在文档测试中使用隐藏的 `try_main`。
///
/// ```
/// # // 被隐藏的行以 `#` 开始
/// # fn try_main() { 
/// let res = try::try_div(10, 2)?;
/// # Ok(()) // 从 try_main 返回
/// # }
/// # fn main() -> Result<(), String>  { // 开始主函数
/// #    try_main().unwrap(); // 调用并展开 try_main，这样出错时测试会 panic
/// # }
pub fn try_div(a: i32, b: i32) -> Result<i32, String> {
    if b == 0 {
        Err(String::from("Divide-by-zero"))
    } else {
        Ok(a / b)
    }
}

```