# 单元测试

除了使用 println!() 或 dbg!() 打印出值这种方法之外，rust 还支持更完善的测试代码写法，而且可以先写测试代码，再实现对应的功能，以实现 TDD (Test-Driven Development)。

单元测试是为了测试我们所写的每一个单元的代码（函数），确保这个单元能完成我们需要的功能，避免所有可能的用法中出现错误。

当你使用 cargo new demo_unit_test --lib 新建一个库的时候，在生成的 src/lib.rs 文件里面会自动出现一个测试样例，提醒你为你的库写好测试。

```rust

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}

```

这里已经包含了一个测试的基本元素。你可以使用 cargo test 来运行这个测试，也是用这个命令来运行所有的后续单元测试。


以下单元测试代码能正常运行的是：

## 答案

A

## 选项 

### 

A

```rust

pub fn add(a: i32, b: i32) -> i32 {
    a + b
}

pub fn add_two(a: i32) -> i32 {
    internal_adder(a, 2)
}

fn internal_adder(a: i32, b: i32) -> i32 {
    a + b
}

#[cfg(test)]
mod tests {

    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }

    use super::*;

    #[test]
    fn test_add() {
        assert_eq!(add(1, 2), 3);
    }
    
    #[test]
    fn internal() {
        assert_eq!(4, internal_adder(2, 2));
    }
    
    #[test]
    #[ignore]
    fn ignored_test() {
        assert_eq!(add(0, 0), 0);
    }
    
}

```

### 即使 ignore 的测试也要能正常编译，否则报错

B 

```rust

pub fn add(a: i32, b: i32) -> i32 {
    a + b
}

pub fn add_two(a: i32) -> i32 {
    internal_adder(a, 2)
}

fn internal_adder(a: i32, b: i32) -> i32 {
    a + b
}

#[cfg(test)]
mod tests {

    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }

    use super::*;

    #[test]
    fn test_add() {
        assert_eq!(add(1, 2), 3);
    }
    
    #[test]
    fn internal() {
        assert_eq!(4, internal_adder(2, 2));
    }
    
    #[test]
    #[ignore]
    fn ignored_test() {
        assert_eq!(add(0.0, 0.0), 0.0);
    }
    
}

```


### 测试代码中需要使用 use super::*; 引入需要进行测试函数

C

```rust

pub fn add(a: i32, b: i32) -> i32 {
    a + b
}

pub fn add_two(a: i32) -> i32 {
    internal_adder(a, 2)
}

fn internal_adder(a: i32, b: i32) -> i32 {
    a + b
}

#[cfg(test)]
mod tests {

    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }


    #[test]
    fn test_add() {
        assert_eq!(add(1, 2), 3);
    }
    
    #[test]
    fn internal() {
        assert_eq!(4, internal_adder(2, 2));
    }
    
    #[test]
    #[ignore]
    fn ignored_test() {
        assert_eq!(add(0, 0), 0);
    }
    
}

```


### 

D

```rust

#[cfg(test)]
mod tests {

    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_ne(result, 4);
    }

}

```