# 表达式与语句

Rust 中的语法分为两大类： 语句 (statement) 和表达式 (Expression)。

语句：指的是要执行的一些操作和产生副作用的表达式。不一定有返回值。有的声明语句没有值，不能作为右值放在赋值语句的等号右边。

表达式：主要用于计算求值。一般有返回值。


语句

    声明语句：用于声明各种语言项，包括变量、静态变量、常量、结构体、函数等，以及通过extern和use关键字引入包和模块。

    表达式语句：特指以分号结尾的表达式。此类表达式求值结果将会被舍弃，并总是返回单元类型（）。单元类型拥有唯一的值，就是它本身。


下面代码中使用有误的地方是：

```rust

// A
// use std::prelude::v1::*;
// pub use core::prelude::rust_2021::*; 
// std::prelude 是自动引入的，一般不需要写，但写了也没有关系。一般只有在写嵌入式系统代码的时候使用 #[no_std] 属性明确指定了不需要标准库，才不会引入标准库

fn main(){

    // 赋值语句
    let x = 5_u32;

    // B
    // 连环赋值?
    let u = v = w = 6;
    let u = (let v = 7);

    let y = {
        let x_squared = x * x;
        let x_cube = x_squared * x;

        // C
        // 将此表达式赋给 `y`
        x_cube + x_squared + x
    };

    let z = {
        // D
        // 分号结束了这个表达式，于是将 `()` 赋给 `z`
        2 * x;
    };

    println!("x is {:?}", x);
    println!("y is {:?}", y);
    println!("z is {:?}", z);

}

```

## 答案

###

B

## 选项

###

A

###

C

###

D


<!-- ref:
https://doc.rust-lang.org/std/prelude/index.html -->