# 注释

Rust 的注释系统是 rust 的魅力来源之一，不仅是自己写注释的时候赏心悦目，而且在阅读标准库和其它优质库时看注释都能感觉到整个 rust 社区的贴心。而且 rust 还能从注释中生成文档，甚至能运行注释中的测试代码。这让 rust 成为最贴近甚至超越经典书籍 [HTDP (How to design programs)](http://htdp.org/) 所提倡的注释的语言。

Rust 常用的注释有:

单行注释

```rust
// Comments always explain what exactly things are.
```

多行注释 (可以嵌套)
```rust
/* Although people generally use single line comments format for 
   multiline comments, but a block comments is also needed.
*/
```

文档注释 (三个斜杠加空格)，常放在函数或特定数据结构的上面，可以用 cargo doc 生成 HTML 文档，以网页形式查看每个函数的注释文档，非常方便于查看及跳转。常用的 IDE 还会提取这里的注释，在光标指向函数名的时候显示。

```rust
/// This add function add /// An asynchronous function from a `Request` to a `Response`.
///
/// The `Service` trait is a simplified interface making it easy to write
/// network applications in a modular and reusable way, decoupled from the
/// underlying protocol. It is one of Tower's fundamental abstractions.
///
/// # Functional
```

模块或库注释，两个斜杠加一个感叹号。常用在 lib.rs 的最开头部分，用于说明整个库的作用

```rust
//! Definition of the core `Service` trait to Tower
//!
//! The [`Service`] trait provides the necessary abstractions for defining
//! request / response clients and servers. It is simple but powerful and is
//! used as the foundation for the rest of Tower.
```

以下例子中的注释的使用和说明不符合注释使用规则的是：

```rust
//! A
//! 这个库要做的事情是 blablabla...

pub mod outer_module {

    // B
    //   - 我是一条注释
    pub mod inner_module {}

    pub mod nested_comments {

        // C

        /* 在 Rust 里面 /* 我们可以使用 /* 嵌套注释 */ */ */

        // 以下三种注释都可以嵌套使用:

        /*   /* */  /** */  /*! */  */
        /*!  /* */  /** */  /*! */  */
        /**  /* */  /** */  /*! */  */
        pub mod dummy_item {}
    }

    pub mod degenerate_cases {

        // D
        // 空的块注释
        /**/

        pub mod dummy_item {}

    }

    /* The next one isn't allowed because outer doc comments
       require an item that will receive the doc */

    // E

    /// 代码最尾部了，我还想写一个文档注释
    ///
}


```

## 答案 

E

## 选项

###

A

###

B

###

C

###

D
