# 函数

函数是 Rust 实现功能的基本代码块。(这也是函数的英文 function 的另一个意思：功能，作用。)

最简洁的函数定义如下：(包含函数定义关键字 fn, 函数名，用来包含参数的一对括号()， 省略了返回值()， 一对花括号，里面放函数体)

```rust
fn main() {}
```

还有一些其它形式的函数，如闭包(能捕获它的花括号的外面的环境变量)，高阶函数(它以其它函数为参数或返回另一个函数)，组合子(Combinators, 以若干函数为参数，并返回一个复杂的函数)

以下函数能正常编译的是：

## 答案

```rust 
fn main() {
    fizzbuzz_to(100);
}

fn is_divisible_by(lhs: u32, rhs: u32) -> bool {
    if rhs == 0 {
        return false;
    }

    lhs % rhs == 0
}

fn fizzbuzz(n: u32) -> () {
    if is_divisible_by(n, 15) {
        println!("fizzbuzz");
    } else if is_divisible_by(n, 3) {
        println!("fizz");
    } else if is_divisible_by(n, 5) {
        println!("buzz");
    } else {
        println!("{}", n);
    }
}

fn fizzbuzz_to(n: u32) {
    for n in 1..=n {
        fizzbuzz(n);
    }
}

```

## 选项

### let 声明语句不返回值，不能作为右值赋值给变量

```rust
fn main() {
    let x = (let y = 6);
}
```

### 声明了返回值必须有返回值

```rust
fn main() {
    let x = plus_one(5);

    println!("The value of x is: {x}");
}

fn plus_one(x: i32) -> i32 {
    x + 1;
}
```

### 有返回值必须声明返回类型 

```rust
fn main() { 5 }
```

