# Rust 的应用领域

Rust 语言应用领域广泛，在命令行工具、WebAssembly、网络编程、嵌入式、系统编程、数据库等等各种领域都有很好的应用。

RustMagazine 在[2021年六月刊](https://rustmagazine.github.io/rust_magazine_2021/chapter_6/hots.html)介绍了一个Rust 在艺术领域的商业应用案例 MORPH，该艺术项目使用486步进电机，86,000个LED和5通道颗粒式合成引擎，控制软件系统使用 Rust 实现，利用的是 nannou 和 koto。  

![Rust usage on a commercial art project](./rust_embedded.png)

以上案例展示了 Rust 在哪方面的应用？ 以下选项最准确的是：

## 答案

```rust
fn main(){
    let rust_usage_domains = ["命令行工具", "WebAssembly", "网络编程", "嵌入式", "系统编程", "数据库", "区块链"];
    for domain in rust_usage_domains {
        if domain.contains("嵌入式") || domain.to_lowercase().contains("embedded") {
            println!("{}", domain);
        }
    }
}
```

## 选项

### A

```rust
fn main(){
    let rust_usage_domains = ["命令行工具", "WebAssembly", "网络编程", "嵌入式", "系统编程", "数据库", "区块链"];
    println!("{:?}", rust_usage_domains);
}
```

### B

```rust
fn main(){
    let rust_usage_domains = ["命令行工具", "WebAssembly", "网络编程", "嵌入式", "系统编程", "数据库", "区块链"];
    loop {
        if domain.includes("嵌入式") || domain.includes("embedded") {
            println!("{}", domain);
        }
    }
}
```

### C

```rust
fn main(){
    let rust_usage_domains = ["命令行工具", "WebAssembly", "网络编程", "嵌入式", "系统编程", "数据库", "区块链"];
    for domain in rust_usage_domains {
        println!("{}", domain);
    }
}
```

<!--
参考链接：  
https://rustmagazine.github.io/rust_magazine_2021/chapter_6/hots.html  
https://t.me/rust_daily_news/4863  
https://twitter.com/nburdy/status/1360220925820604419  
https://www.dw.com/en/the-kinetic-super-sculpture/av-58618165  
-->
