# Hello World

编写一个输出 "Hello,World!" 的 Rust 程序，以下错误的是？

## 答案

```rust
fn main() {
    let str1 = "Hello,";
    let str2 = "World!";
    println!("{}", str1+str2);
}
```

## 选项

### 直接打印

```rust
fn main() {
    let str1 = "Hello,World!";
    println!("{}", str1);
}
```

### 使用格式划宏拼接

```rust
fn main() {
    let str = "Hello";
    let str = format!("{},World", str);
    println!("{}", str);
}
```

### 使用 String::from

```rust
fn main() {
    let str1 = String::from("Hello");
    let str2 = String::from("World");
    let str = format!("{},{}!", str1, str2);
    println!("{}", str);
}

```

### 使用mut+push_str

```rust
fn main() {
    let mut str1 = String::from("Hello,");
    let str2 = String::from("World!");
    str1.push_str(str2.as_str());
    println!("{}", str1);
}
```
