# 结构体里的生命周期(I)

以下对Rust结构体生命周期使用中，正确的代码是哪一项？

## 答案

```rust
struct Piece<'a>{
  slice:&'a [u8] // 表明slice是来自外部对象的一个借用，'a只是一个生命周期形参
}
 
 
// Piece的定义里面，'a 表示vec的生命周期，
// 下面的例子调用，vec的生命周期至少应该大于等于piece的生命周期
// 简单说vec存活的作用域应该大于等于piece的存活作用域
fn test(){
  let vec = Vec::<u8>::new();
  let piece = Piece{slice: vec.as_slice()}; 
}
```

## 选项

### 结构体内含有的引用变量，函数返回后，生命周期就结束了

```rust
struct Piece<'a>{
  slice:&'a [u8] // 表明slice是来自外部对象的一个借用，'a只是一个生命周期形参
}

fn test_2()->Piece{
  let vec = Vec::<u8>::new();
  let piece = Piece{slice: vec.as_slice()}; 
  piece // compile error: ^^^^^ returns a value referencing data owned by the current function
}
```

### expected named lifetime parameter

```rust
struct Piece{
  slice:& [u8] // 表明slice是来自外部对象的一个借用，'a只是一个生命周期形参
}
 
 
// Piece的定义里面，'a 表示vec的生命周期，
// 下面的例子调用，vec的生命周期至少应该大于等于piece的生命周期
// 简单说vec存活的作用域应该大于等于piece的存活作用域
fn test(){
  let vec = Vec::<u8>::new();
  let piece = Piece{slice: vec.as_slice()}; 
}
```

### 结构体内持有的变量应该在构建的时候存活

```rust
struct Piece<'a>{
  slice:&'a [u8] // 表明slice是来自外部对象的一个借用，'a只是一个生命周期形参
}

fn test(){
    let vec
    {
        vec = Vec::<u8>::new();
    }
    let piece = Piece{slice: vec.as_slice()}; 
}
```
