# fizzbuzz

现在你了解了 Rust 的基础，先试着自己写一个 fizzbuzz 程序，规则如下：

从 1 打印到 100， 当数字能被 3 整除时，打印 fizz, 能被 5 整除时，打印 buzz, 能被 15 整除时，打印 fizzbuzz, 否则，直接打印数字。

先自己写完再来对照下面的写法并答题。  
(再思考一下 fizzbuzzwhizz 应该怎么写呢：  
- 被 3 整除时，打印 fizz  
- 被 5 整除时，打印 buzz  
- 被 7 整除时，打印 whizz  
- 能同时整除上面的数字时，都要打印出来，如 35 要打印 buzzwhizz, 105 要打印 fizzbuzzwhizz  
)  

以下打印 fizzbuzz 的程序，不能正确输出结果的是:

## 答案

```rust
fn main() {
    (1 ..= 100)
        .map(|i| {
            if i % 15 == 0 {
                println!("fizzbuzz");
            } else if i % 3 == 0  {
                println!("fizz");
            } else if i % 5 == 0 {
                println!("buzz");
            } else {
                println!("{}", i);
            }
        });        
}
```

### map 是惰性求值，不能直接输出，使用 for_each 可正确运行

```rust
fn main() {
    (1 ..= 100)
        .for_each(|i| {
            if i % 15 == 0 {
                println!("fizzbuzz");
            } else if i % 3 == 0  {
                println!("fizz");
            } else if i % 5 == 0 {
                println!("buzz");
            } else {
                println!("{}", i);
            }
        });        
}
```

### 使用 for 循环和 if else 条件判断

```rust

fn main() {
    for i in 1..=100 {
        if i % 15 == 0 {
            println!("fizzbuzz");
        } else if i % 3 == 0  {
            println!("fizz");
        } else if i % 5 == 0 {
            println!("buzz");
        } else {
            println!("{}", i);
        }
    }       
}

```

### 使用 for 循环和 match 匹配  

```rust
fn main() {
    for i in 1..=100 {
        match (i % 3 == 0, i % 5 == 0) {
            (true, true) => println!("fizzbuzz"),
            (true, false) => println!("fizz"),
            (false, true) => println!("buzz"),
            (false, false) => println!("{}", i),
        }
    }       
}
```