# 文档

Rust 社区非常重视文档，并提供了各种工具，使得文档形式多样，容易编写。Rust 文档支持 markdown，使用 rustdoc 解析并转换成 HTML，生成漂亮的、可搜索的文档页面。

首先，在每个库或可运行程序的 lib.rs 或 main.rs 文件最头部，会使用 ``` //! ``` 说明库的用途。

```rust
//! This crate is for ...
//!
```

也可以使用 #[doc=...] 方式包含文本文件的方式，带入大段的说明：

```rust
#[doc = include_str!("../../README.md")]
```

其次，在每个模块，函数，结构体等的上面使用 ```///``` 给它们添加对应的说明文档; 你还可以在这里写上对应的测试代码，在运行 cargo test 的时候这些文档里面的代码也会一起测试并给出结果。

```rust
pub use bar::Bar;

/// bar docs
pub mod bar {
    /// the docs for Bar
    pub struct Bar;

    /// the docs for funtion
    pub fn baz() {}
}
```

当你写了一些文档只准备自己看或给看源代码的人看，而不准备让它解析到生成的文档中去，可以使用 ```#[doc(hidden)]``` 让它不渲染到文档里面。

写完程序和文档之后，使用 cargo doc 生成对应的文档。

如果你需要单独的文档（使用 markdown 编写），而不是写在程序的注释里面，可以使用 [mdbook](https://github.com/rust-lang/mdBook) 这个工具。

下面的文档测试代码使用有误的是：

```rust

//! This is a test crate about rustdoc
//! 
//! We will have lib description doc, mod doc, struct doc, function doc, include attribute, hidden attribute, etc

// == A ==
/// bar docs
pub mod bar {
    
    // == B ==
    /// the docs for Bar
    pub struct Bar;

    // == C == 
    /// the docs for funtion
    pub fn baz() {}

    // == D ==
    #[doc(include("readme.md"))]

    #[doc(hidden)]
    fn private() {}
}



```

## 答案

D

## 选项

###

A

###

B

###

C



<!-- 
ref:
https://doc.rust-lang.org/stable/rustdoc/
https://doc.rust-lang.org/book/ch14-02-publishing-to-crates-io.html#commenting-contained-items
https://doc.rust-lang.org/stable/rustdoc/write-documentation/documentation-tests.html
https://zhuanlan.zhihu.com/p/352387200
-->
