# 返回值

在 rust 中，任何函数都有返回类型，当函数返回时，会返回一个该类型的值。

有时候我们看到 main() 函数没有写返回值，实际只是省略了返回的 (), 完整的 main 签名如下：

```rust
fn main() -> () {}
```

函数可以返回单个值

```rust
fn inc(n: i32) -> i32 { n + 1 }
```

可以以元组形式返回多个值

```rust
fn pow_2_3(n: i32) -> (i32, i32) {
  (n*n, n*n*n)
}
```

可以使用 return 提高返回值，如在条件判断或循环体中，提前用 return 返回值并结束当前函数。

还有一种称为发散函数，返回 never type, 这个只需要了解，一般很少会用，实际它不会返回，它使用感叹号 ! 作为返回类型：

```rust
fn diverging() -> ! {
  panic!("This function will never return");
}
```

在 match 或 if 条件判断中，如果将每个分支的值返回，需要每个分支返回相同的类型。

以下例子中，能正确返回值的是：

## 答案

```rust
fn add(ele: &mut i32) {
    *ele += 1;
}
```

## 选项

###

```rust
fn add(ele: &mut i32) {
    ele += 1;
}
```

###

```rust
fn add(ele: &mut i32) -> i32 {
    ele += 1;
}
```

###

```rust
fn add(ele: i32) -> i32 {
    ele += 1;
}
```

