# Rust 原生类型

Rust 提供的原生类型有：

标量类型：
- 带符号整数 i8, i16, i32, i64, i128 和 isize
- 无符号整数 u8, u16, u32, u64, u128 和 usize
- 浮点数 f32, f64
- 字符 char, 每个字符占用 4 字节
- 布尔值 true 或 false
- 单元类型，即 ()

组合类型
- 数组 array 如 [1, 2, 3]
- 元组 tuple 如 (1, true)
- 切片 slice

以下不会出现编译错误的是

## 答案 

```rust
fn main() {
    let a = 42;
    let a = 4294967296_i64;
    let mut s = "12";
    let s = "true";
    let s = false;
}
```

## 选项

### 变量类型不可变

```rust
fn main() {
    let mut mutable = 12; 
    mutable = 21;

    mutable = true;
}
```

### 变量类型 u32 不能出现负值

```rust
fn main() {
    println!("1 + 2 = {}", 1i32 + 2);

    println!("1 - 2 = {}", 1u32 - 2);
}
```

### 切片是不定长类型，只能以引用形式赋值或使用。

```rust
fn main() {
    let xs: [i32] = [1, 2, 3, 4, 5];

    let ys: [i32; 500] = [0; 500];
}
```
