# rust 数据类型

使用计算机编程是为了处理各种各样的数据，每种数据都必定有类型。

这也就是说，类型是指数据在内存中是怎么存储，读取之后怎么解析这一段内存中的数据，以及对这种类型的数据可以怎么样进行操作。

Rust 语言设计者对于在内存中操作数据的要求非常高，比如在官方首页的 "Why Rust" 一节，提到了要做到 "memory-efficient" 和 "memory-safe"，就是内存高效和内存安全，基于这样的设计目标，Rust 的数据类型设计非常精细。所以深入理解 Rust 类型是学好 Rust 编程的基础。

学习 Rust 类型，需要了解这个类型保存在内存的什么地方(栈，堆，静态数据区 等等)，占用多大空间(特别是在栈上占用多少空间)，怎么操作(如 push, push_str, insert, 等等)。

下面简要说明一下具体类型。

Rust 的标量类型(scalar type) 是指表示为单一值的类型，有：
- 整数 int / integer
- 浮点数 float
- 布尔值 bool / Boolean
- 单个字符 char / character

多个数据紧挨着排列的数据：
- 元组 Tuple
- 数组 Array
- 矢量 Vector
- 切片 Slice
  
用户定义类型
- 结构体 Struct
- 枚举 Enum
- 联合体 Union (较少用)

其它类型
- 函数
- 闭包
- 引用
- 裸指针
- 函数指针
- Trait 对象

下面的代码不能打印出标量值的是：

## 答案

```rust
fn main() {
    println!("{}", (1,));
}
```

## 选项

### 整数

```rust
fn main() {
    println!("{}", 1);
}
```


### 浮点数

```rust
fn main() {
    println!("{}", -0.1);
}
```


### 字符

```rust
fn main() {
    println!("{}", ("1"));
}
```



<!--  
参考：
    https://www.rust-lang.org/
    https://doc.rust-lang.org/book/ch03-02-data-types.html
    https://doc.rust-lang.org/reference/types.html 
->