# Cargo 的使用

当项目变大时，通常的做法是将代码重构为更小、更易于管理的单元，即模块或程序库。你还需要工具来管理相关的依赖项。

Cargo 是能够帮助你处理上述所有事情的工具。

Rust 编写的程序库被称为 crate。 通常，crate 放置在三个地方以供使用：本地目录、 GitHub之类的在线Git代码库，或者像 crates.io 这样的在线托管 crate 服务。 

Cargo 支持上述所有来源的软件包。


最常用的Cargo 命令有:
- cargo new my_new_project     // 新建二进制程序项目
- cargo new my_new_lib --lib   // 新建库项目
- cargo run                    // 构建项目的带调试信息的程序，并运行
- cargo run --release          // 构建项目的发布优化程序，并运行
- cargo build --release        // 构建项目的发布优化程序
- cargo test                   // 运行项目的单元测试，集成测试，以及文档测试
- cargo bench                  // 基础测试
- cargo doc --open             // 构建项目本身的及所有依赖项的文档，并打开
- cargo install                // 安装一个二进制命令
- cargo run --example my_example  // 运行项目 examples 目录内的 my_example 文件，以直观的查看示例效果


实际上，cargo 甚至还有一个命令能同时帮你编译代码，提示错误并提供地道写法的优化建议，在学习 rust 的过程中经常运行它会让你更快的学习到 rust 并提升代码质量，它是： 

## 答案

### clippy 是 cargo 的一个非常有用的 lint 工具，在学习 rust 的时候不时运行 cargo clippy 会学到很多有用的写法，提升代码质量。

cargo clippy

## 选项

### A

cargo fmt

### B

cargo fix

### C

cargo search


<!--
参考链接：  
https://doc.rust-lang.org/cargo/ 
-->