# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python 安装交互式查询程序
# 描述：交互式提示程序，用户选择对应平台后，能正确输出对应平台上的安装包下载连接

if __name__ == '__main__':
    install = {
        "Windows": "请下载 Windows 安装包安装：https://www.python.org/downloads/windows/",
        "CentOS": "使用yum包管理器，执行命令：yum install -y python3",
        "Ubuntu": "使用apt-get包管理器，执行命令：apt-get install -y python3",
        "MacOS": "安装brew包管理器，然后执行命令： brew install python3",
    }

    shortcut_keys = {}
    for platform in install:
        key = platform[0].lower()
        shortcut_keys[key] = platform

    while True:
        ret = input("请选择安装平台[w/c/u/m, 按q退出]：")
        platform = shortcut_keys.get(ret)

        if ret == 'q':
            break

        if platform is None:
            print("不支持的平台")
            continue

        doc = install.get(platform)
        print(f"{platform}: {doc}")
