# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python PyQt 进度条(1)
# 描述：使用 QThread 发送信号，接收信号一方打印并结束程序
import sys
from PyQt5.QtCore import QThread, pyqtSignal
from PyQt5.QtWidgets import QApplication


class ProgressInfo:
    def __init__(self, progress, msg):
        self.progress = progress
        self.msg = msg


class QProgressThread(QThread):
    _signal = pyqtSignal(ProgressInfo)

    def __init__(self, runner):
        super(QProgressThread, self).__init__()
        self.runner = runner

    def __del__(self):
        self.wait()

    def run(self):
        def on_progress(progress, info):
            info = ProgressInfo(progress, info)
            self._signal.emit(info)

        self.runner(on_progress)


if __name__ == "__main__":
    app = QApplication(sys.argv)
    p = QProgressThread(
        lambda on_progress: on_progress(0, "hello PyQT world!")
    )

    def on_signal(info):
        print("accept info from signal:", info.msg)
        QApplication.quit()

    p._signal.connect(on_signal)
    p.start()
    sys.exit(app.exec_())
