# requests post 请求

requests post 请求

```python
# -*- coding: UTF-8 -*-
import requests

def get_response(url, data, headers=None):
    # TODO(You): 请在此实现代码
    return result

if __name__ == '__main__':
    headers = {
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.146 Safari/537.36"
    }
    data = {
        "key1": "value1",
        "key2": "value2"
    }
    url = "http://httpbin.org/post"
    html = get_response(url, data, headers)
    print(html)
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import requests


def get_response(url, data, headers=None):
    response = requests.post(url, data, headers)
    return response.text


def test():
    headers = {
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.146 Safari/537.36"
    }
    data = {
        "key1": "value1",
        "key2": "value2"
    }
    url = "http://httpbin.org/post"
    html = get_response(url, data, headers)
    print(html)

if __name__ == '__main__':
    test()
```

## 答案

```python
def get_response(url, data, headers=None):
    response = requests.post(url, data, headers)
    result = response.text
    return result
```

## 选项

### A

```python
def get_response(url, data, headers=None):
    response = requests.get(url, headers， data)
    result = response.text
    return result
```

### B

```python
def get_response(url, data, headers=None):
    result = requests.post(url, data, headers)
    return result
```

### C

```python
def get_response(url, data, headers=None):
    response = requests.post(url, data, headers)
    result = response.text()
    return result
```
