# Python 访问控制

分别编写类内部的私有方法，模块级别的私有方法

请选出下列能**代码和注释一致**的代码。

## template

```python
class Test:
    def __init__(self) -> None:
        pass

    def test(self):
        self.__test()

    def __test(self):
        '''类内部的私有方法'''
        print("test")


def _func():
    '''模块级别的私有方法'''
    print("file private")

if __name__ == '__main__':
    t = Test()
    t.test()
```

## 答案

```python
class Test:
    def test(self):
        self.__test()

    def __test(self):
        '''类内部的私有方法'''
        print("test")

def _func():
    '''模块级别的私有方法'''
    print("file private")

if __name__ == '__main__':
    t = Test()
    t.test()
```

## 选项

### A

```python
class Test:
    def test(self):
        self._test()

    def _test(self):
        '''类内部的私有方法'''
        print("test")

def _func():
    '''模块级别的私有方法'''
    print("file private")

if __name__ == '__main__':
    t = Test()
    t.test()
```

### B

```python
class Test:
    def test(self):
        self.__test__()

    def __test__(self):
        '''类内部的私有方法'''
        print("test")

def _func():
    '''模块级别的私有方法'''
    print("file private")

if __name__ == '__main__':
    t = Test()
    t.test()
```

### C

```python
class Test:
    def test(self):
        self.__test()

    def __test(self):
        '''类内部的私有方法'''
        print("test")

def func():
    '''模块级别的私有方法'''
    print("file private")

if __name__ == '__main__':
    t = Test()
    t.test()
```
