# Python with-as 语句(1)

JSON文件读写

```python
# -*- coding: UTF-8 -*-
import json

def load_json(file):
    # TODO(You): 实现加载json文件代码

def dump_json(file, obj):
    # TODO(You): 实现将dict写入json文件的代码

if __name__ == '__main__':
    data = {
        'test': 1,
    }
    dump_json('test.json', data)
    load_json('test.json')
```

请选出下列能**正确**实现这一功能的选项。

## template

```python

import json


def load_json(file):
    with open(file, 'r') as f:
        return json.loads(f.read())


def dump_json(file, obj):
    with open(file, 'w') as f:
        f.write(json.dumps(obj, indent=2, ensure_ascii=False))

if __name__ == '__main__':
    data = {
        'test': 1,
    }
    dump_json('test.json', data)
    load_json('test.json')
```

## 答案

```python
def load_json(file):
    with open(file, 'r') as f:
        return json.loads(f.read())

def dump_json(file, obj):
    with open(file, 'w') as f:
        f.write(json.dumps(obj, indent=2, ensure_ascii=False))
```

## 选项

### A

```python
def load_json(file):
    with open(file, 'w') as f:
        return json.loads(f.read())

def dump_json(file, obj):
    with open(file, 'r') as f:
        f.write(json.dumps(obj, ensure_ascii=False, indent=2))
```

### B

```python
def load_json(file):
    with open(file, 'w') as f:
        return json.loads(f.read())

def dump_json(file, obj):
    with open(file, 'r') as f:
        f.write(json.dumps(obj, indent=2, ensure_ascii=False))
```

### C

```python
def load_json(file):
    with open(file, 'r') as f:
        return json.loads(f.read())

def dump_json(file, obj):
    with open(file, 'w') as f:
        f.write(json.dumps(obj, ensure_ascii=False, indent=2))
```
