# Python with-as 语句(2)

实现一个范围耗时统计类。 实现了 `__enter__` 和 `__exit__` 成员的类，可以通过 with as 语法使用，程序进入和离开范围的时候会自动调用 `__enter__` 和 `__exit__` 方法。

```python
# -*- coding: UTF-8 -*-
import time

class TimeSpan:
    # TODO(You): 请正确实现计时器的__enter__和__exit成员

if __name__ == '__main__':
    with TimeSpan() as t:
        for i in range(0, 1000):
            print(i)
```

下列哪个实现是**错误的**？

## template

```python
import time

class TimeSpan:
    def __init__(self) -> None:
        self.start = None

    def __enter__(self):
        self.end = None
        self.start = time.time()

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.end = time.time()
        print('耗时:{}毫秒'.format((self.end-self.start)))

if __name__ == '__main__':
    with TimeSpan() as t:
        for i in range(0, 1000):
            print(i)
```

## 答案

```python
class TimeSpan:
    def __enter__(self):
        return time.time()

    def __exit__(self, exc_type, exc_val, exc_tb):
        end = time.time()
        print('耗时:{}毫秒'.format((end-exc_val)))
```

## 选项

### A

```python
class TimeSpan:
    def __enter__(self):
        self.start = time.time()

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.end = time.time()
        print('耗时:{}毫秒'.format((self.end-self.start)))
```

### B

```python
class TimeSpan:
    def __enter__(self):
        self.end = None
        self.start = time.time()

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.end = time.time()
        print('耗时:{}毫秒'.format((self.end-self.start)))
```

### C

```python
class TimeSpan:
    def __enter__(self):
        self.end = None
        self.start = time.time()
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.end = time.time()
        print('耗时:{}毫秒'.format((self.end-self.start)))
```
