# Python 中文处理(1)

获取中文个数

```python
# -*- coding: UTF-8 -*-
import re

def getnum_of_cn(inputdata):
    '''计算字符串中 中文字符 数量'''
    # TODO(You): 请编写正则查询代码
    return len(chi)

def test():
    n = getnum_of_cn('你好，lajfldkjaklda123')
    print(n)

if __name__ == '__main__':
    test()
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import re


def getnum_of_cn(inputdata):
    '''计算字符串中 中文字符 数量'''
    chi = re.findall(r'[\u4E00-\u9FFF]', inputdata)
    return len(chi)


def test():
    n = getnum_of_cn('你好，lajfldkjaklda123')
    print(n)

if __name__ == '__main__':
    test()
```

## 答案

```python
chi = re.findall(r'[\u4E00-\u9FFF]', inputdata)
```

## 选项

### A

```python
chi = re.find(r'[\u4E00-\u9FFF]', inputdata)
```

### B

```python
chi = inputdata.findall(r'[\u4E00-\u9FFF]')
```

### C

```python
chi = re.findall(r'\u4E00-\u9FFF', inputdata)
```
