# pandas dataframe 3.1

通过 loc 操作，过滤中间人信息，以下正确的操作是？

## template

```python
import pandas as pd

if __name__ == '__main__':
    d = {
        'name': ['Alice', 'Bob', 'Middle'],
        'age': [10, 12, 0],
        'send': ['在么', '你说呢？', '今晚有事']
    }

    df = pd.DataFrame(d, columns=['name', 'age', 'send'])

    print("取出name不等于‘Middle'的数据")
    alice_bob = df.loc[df['name'] != 'Middle']
    print(alice_bob)
```

## 答案

```python
import pandas as pd

if __name__ == '__main__':
    d = {
        'name': ['Alice', 'Bob', 'Middle'],
        'age': [10, 12, 0],
        'send': ['在么', '你说呢？', '今晚有事']
    }

    df = pd.DataFrame(d, columns=['name', 'age', 'send'])

    print("取出name不等于‘Middle'的数据")
    alice_bob = df.loc[df['name'] != 'Middle']
    print(alice_bob)
```

## 选项

### A

```python
import pandas as pd

if __name__ == '__main__':
    d = {
        'name': ['Alice', 'Bob', 'Middle'],
        'age': [10, 12, 0],
        'send': ['在么', '你说呢？', '今晚有事']
    }

    df = pd.DataFrame(d, columns=['name', 'age', 'send'])

    print("取出name不等于‘Middle'的数据")
    alice_bob = df.loc(lambda item:item['name'] != 'Middle')
    print(alice_bob)
```

### B

```python
import pandas as pd

if __name__ == '__main__':
    d = {
        'name': ['Alice', 'Bob', 'Middle'],
        'age': [10, 12, 0],
        'send': ['在么', '你说呢？', '今晚有事']
    }

    df = pd.DataFrame(d, columns=['name', 'age', 'send'])

    print("取出name不等于‘Middle'的数据")
    alice_bob = df.loc['name'] != 'Middle'
    print(alice_bob)
```

### C

```python
import pandas as pd

if __name__ == '__main__':
    d = {
        'name': ['Alice', 'Bob', 'Middle'],
        'age': [10, 12, 0],
        'send': ['在么', '你说呢？', '今晚有事']
    }

    df = pd.DataFrame(d, columns=['name', 'age', 'send'])

    print("取出name不等于‘Middle'的数据")
    alice_bob = df.loc[df['name'] == 'Middle']
    print(alice_bob)
```
