# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：路由器
# 描述：编写一个路由服务，主持注入路由配置，正确处理请求参数

from error_code import ErrorCode
import json
import logging
import traceback
logger = logging.getLogger(__name__)


class Router:
    def __init__(self, routes) -> None:
        self.routes = routes

    def dispatch(self, http_request_str):
        assert http_request_str is not None
        assert type(http_request_str) == type('')

        req_path = None
        req = None
        try:
            http_request = json.loads(http_request_str)
            req_path = http_request.get('path')
            req = http_request.get('data')
        except Exception as e:
            logger.error(f"parse data exception:{str(e)}")
            return {'err': ErrorCode.INVALID_PARAMETERS}, 200

        if req_path is None or self.routes.get(req_path) is None:
            return {'err': ErrorCode.NOT_FOUND}, 404

        try:
            handler = self.routes.get(req_path)
            return handler(req), 200
        except Exception as e:
            logger.error(f"route to '{req_path}' exception:{str(e)}")
            logger.error(traceback.format_exc())
            return {'err': ErrorCode.FAILED}, 500


if __name__ == '__main__':
    server = Router({
        '/': lambda req: print(f'goto home:{str(req)}')
    })

    server.dispatch(json.dumps({
        'path': '/',
        'data': ["Hello", "World!"]
    }))
