# Python 类的基本使用(2)

在上一题的基础上。通过类的集成，可以扩展原有的类。例如继承`KeyValueSet`容器类，扩展功能，支持类似redis的 `hset`/`hget`/`hkeys` 扩展接口

基本代码框架如下

```python
from key_value_set import KeyValueSet


class HashKeyValueSet(KeyValueSet):
    def __init__(self) -> None:
        super().__init__()

    def hset(self, hash_key, key, value):
        # TODO(You): 请在此实现 hset 方法

    def hget(self, hash_key, key):
        hash_set = self.get(hash_key)
        if hash_set is None:
            return None
        else:
            return hash_set.get(key)

    def hkeys(self, hash_key):
        hash_set = self.get(hash_key)
        if hash_set is None:
            return []
        else:
            return hash_set.keys()
```

用例如下：

```python
if __name__ == '__main__':
    hashset = HashKeyValueSet()

    hashset.hset('puzzle', 'hello', 'world!')
    hashset.hset('puzzle', 'monkey', 'king!')
    hashset.hset('puzzle', 'tomorrow', 'is another day')
    hashset.hset('puzzle', 'good', 'bye!')

    keys = hashset.hkeys('puzzle')
    for key in keys:
        ret = input("猜一猜下半句是什么？ {} -> :".format(key))
        value = hashset.hget('puzzle', key)
        if ret == value:
            print('你太厉害了，这都能猜得到！')
        else:
            print('哈哈，肯定猜不到得啦：{}->{}'.format(key, value))
```

请选出下面对`TODO`的实现代码中，<span style="color:red">错误</span> 的选项。

## template

```python
class HashKeyValueSet(KeyValueSet):
    def __init__(self) -> None:
        super().__init__()

    def hset(self, hash_key, key, value):
        hash_set = self.get(hash_key)
        if hash_set is None:
            hash_set = {}
            hash_set[key] = value
            self.set(hash_key, hash_set)
        else:
            hash_set[key] = value
            self.set(hash_key, hash_set)

    def hget(self, hash_key, key):
        hash_set = self.get(hash_key)
        if hash_set is None:
            return None
        else:
            return hash_set.get(key)

    def hkeys(self, hash_key):
        hash_set = self.get(hash_key)
        if hash_set is None:
            return []
        else:
            return hash_set.keys()

if __name__ == '__main__':
    hashset = HashKeyValueSet()

    hashset.hset('puzzle', 'hello', 'world!')
    hashset.hset('puzzle', 'monkey', 'king!')
    hashset.hset('puzzle', 'tomorrow', 'is another day')
    hashset.hset('puzzle', 'good', 'bye!')

    keys = hashset.hkeys('puzzle')
    for key in keys:
        ret = input("猜一猜下半句是什么？ {} -> :".format(key))
        value = hashset.hget('puzzle', key)
        if ret == value:
            print('你太厉害了，这都能猜得到！')
        else:
            print('哈哈，肯定猜不到得啦：{}->{}'.format(key, value))
```

## 答案

```python
hash_set = self.get(hash_key,{key:value})
self.set(hash_key, hash_set)
```

## 选项

### A

```python
self.set(hash_key, {key:value})
```

### B

```python
hash_set = self.get(hash_key)
if hash_set is None:
    hash_set = {key:value}
else:
    hash_set[key] = value

self.set(hash_key, hash_set)
```

### C

```python
hash_set = self.get(hash_key)
if hash_set is None:
    hash_set = {key:value}
    self.set(hash_key, hash_set)
else:
    hash_set[key] = value
    self.set(hash_key, hash_set)
```
