# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python 结构化模式匹配(2)
# 描述：结构化模式匹配支持对各种Python数据类型进行匹配。请使用 Python 3.10+ 版本测试本代码。

class Car:
    __match_args__ = ('key', 'name')

    def __init__(self, key, name):
        self.key = key
        self.name = name


if __name__ == '__main__':

    while True:
        try:
            expr = eval(input('Expr: '))
        except:
            print('无效的Python代码，请输入合法的Python数据类型')
            continue
        match expr:
            case(0, x):
                print(f'(0, {x})')
            case['a', x, 'c']:
                print(f"'a', {x!r}, 'c'")
            case {'foo': bar}:
                print(f"{{'foo': {bar}}}")
            case[1, 2, *rest]:
                print(f'[1, 2, *{rest}]')
            case {'x': x, **kw}:
                print(f"{{'x': {x}, **{kw}}}")
            case Car(key=key, name='Tesla'):
                print(f"Car({key!r}, 'TESLA!')")
            case Car(key, name):
                print(f"Car({key!r}, {name!r})")
            case 1 | 'one' | 'I':
                print('one')
            case['a' | 'b' as ab, c]:
                print(f'{ab!r}, {c!r}')
            case(x, y) if x == y:
                print(f'({x}, {y}) with x==y')
            case 'q':
                print('quit')
                break
            case _:
                print('no match')
