# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python 线程池
# 描述：使用线程池并发下载图片

from concurrent.futures import ThreadPoolExecutor
from image_download import download_img


def test():
    urls = [
        "https://img-ask.csdnimg.cn/upload/1623844642974.jpg",
        "https://img-ask.csdnimg.cn/upload/1623844642974.jpg",
        "https://img-mid.csdnimg.cn/release/static/image/mid/ask/754909759626128.jpg",
        "https://img-ask.csdn.net/upload/201510/22/1445491909_384819.jpg",
    ]
    with ThreadPoolExecutor(max_workers=5) as exe:
        exe.map(download_img, urls)


if __name__ == '__main__':
    test()
