# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python 迷你滤镜PS
# 描述：实现一个包含 “高斯滤镜”/“中值滤波”/“维纳滤波”/“多维均匀过滤器” 的迷你PS软件，支持选择滤镜并将对比照片显示出来

from scipy import misc, ndimage, signal
import matplotlib.pyplot as plt
import numpy as np
from PIL import Image


def plot_two(left, right):
    fig = plt.figure()
    ax1 = fig.add_subplot(121)
    ax2 = fig.add_subplot(122)
    ax1.imshow(left)
    ax2.imshow(right)
    plt.show()


def select_filter(image):
    print(image.shape)
    filters = [
        {
            'option': 'g',
            'name': '高斯滤镜( gaussian_filter )',
            'filter': lambda: ndimage.gaussian_filter(image, sigma=6)
        },
        {
            'option': 'm',
            'name': '中值滤波( median_filter )',
            'filter': lambda: ndimage.median_filter(image, size=6)
        },
        {
            'option': 'w',
            'name': '维纳滤波( wiener )',
            'filter': lambda: signal.wiener(image, mysize=6)
        },
        {
            'option': 'u',
            'name': '多维均匀过滤器( uniform_filter )',
            'filter': lambda: ndimage.uniform_filter(image, size=6)
        },
    ]

    print("本迷你PS软件支持以下滤镜：")
    filter_dict = {}
    for filter in filters:
        filter_dict[filter['option']] = filter
        print("* {} : {}".format(filter['option'], filter['name']))

    options = '/'.join(list(map(lambda f: f['option'], filters)))

    while True:
        ret = input(f"请选择滤镜[ {options}]:")
        filter = filter_dict.get(ret)
        if filter is None:
            print("不支持的选项，请重新选择。")
        else:
            return filter['filter']()


if __name__ == '__main__':
    image = misc.face()
    blurred = select_filter(image)
    plot_two(image, blurred)
