# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python 曲线拟合
# 描述：使用 SciPy 拟合曲线

import numpy as np
from scipy.optimize import curve_fit
import matplotlib.pyplot as plt


def func(x, a, b, c):
    return a * np.cos(x) - b*np.sin(x) + c*np.cos(2*x)

if __name__ == '__main__':
    i = np.linspace(0, 4, 50)
    x = func(i, 2.5, 1.3, 0.5)

    np.random.seed(1729)
    x_noise = 0.2 * np.random.normal(size=i.size)
    popt, pcov = curve_fit(func, i, x+x_noise)
    plt.plot(i, func(i, *popt), '-')

    plt.show()
