# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python PyQt 进度条(2)
# 描述：请先完成上一题。封装一个能显示进度条的 PyQT GUI 对话框
import sys
import math
from PyQt5.QtWidgets import QApplication, QWidget, QPushButton, QProgressBar, QVBoxLayout, QMessageBox
from q_progress_thread import QProgressThread


class QRunnerProgressBar(QWidget):
    def __init__(self, count, tip, runner):
        super(QRunnerProgressBar, self).__init__()
        self.setWindowTitle('QRunnerProgressBar')

        self.vbox = QVBoxLayout()

        self.btn = QPushButton(tip)
        self.btn.clicked.connect(self.btnFunc)
        self.vbox.addWidget(self.btn)

        self.pbar = QProgressBar(self)
        self.pbar.setValue(0)
        self.vbox.addWidget(self.pbar)

        self.setLayout(self.vbox)
        self.resize(300, 100)
        self.show()

        self.count = count
        self.runner = runner

    def btnFunc(self):
        self.thread = QProgressThread(self.runner)
        self.thread._signal.connect(self.signal_accept)
        self.thread.start()
        self.btn.setEnabled(False)

    def signal_accept(self, info):
        percent_value = int(math.floor(info.progress*100/self.count))
        self.pbar.setValue(int(percent_value))
        self.setWindowTitle(info.msg)
        if self.pbar.value() == 99:
            self.pbar.setValue(0)
            self.btn.setEnabled(True)

    def closeEvent(self, event):
        self.thread = None


if __name__ == "__main__":
    app = QApplication(sys.argv)
    p = QRunnerProgressBar(
        100,
        '看资料+做题，就有技能树进度',
        lambda on_progress: on_progress(50, 'Python技能树->PyQT')
    )
    sys.exit(app.exec_())
