# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python PyQt 进度条(3)
# 描述：请先完成上一题。使用封装好的 PyQT 进度条显示2008年1月到本月的每个月1号进度。经过层层封装，到这里主要是上层的组合逻辑了。

from datetime import date, timedelta
from calendar import monthrange
from datetime import timedelta
import sys
import time

from PyQt5.QtWidgets import QApplication
from q_progress_bar import QRunnerProgressBar


class MonthProgress:
    def __init__(self, start_month, finish_month):
        self.start = start_month
        self.finish = finish_month

    def __month_count(self):
        count = 0
        d1 = self.start
        d2 = self.finish
        while True:
            mdays = monthrange(d1.year, d1.month)[1]
            d1 += timedelta(days=mdays)
            if d1 <= d2:
                count += 1
            else:
                break
        return count

    def __for_each_month(self, on_progress):
        d = self.start
        finish = self.finish
        progress = 0
        while d < finish:
            time.sleep(0.1)
            on_progress(progress, d.__str__())
            d = d+timedelta(monthrange(d.year, d.month)[1])
            progress += 1

    def run(self):
        app = QApplication(sys.argv)
        bar = QRunnerProgressBar(
            self.__month_count(),
            "如果每个月都有技能树进度条...",
            self.__for_each_month
        )
        bar.show()
        sys.exit(app.exec_())


if __name__ == "__main__":
    month_progress = MonthProgress(
        date(2008, 1, 1),
        date.today(),
    )

    month_progress.run()
