# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python 匿名表达式
# 描述：Python 高阶函数编程，使用 lambda 表达式获取key，将list转成dict


def list_to_dict(list, key_func):
    d = {}
    for item in list:
        k = key_func(item)
        v = item
        list = d.get(k)
        if list is None:
            d[k] = [v]
        else:
            d[k].append(v)

    return d


if __name__ == '__main__':
    list = [
        {"name": "alice", "age": 100},
        {"name": "middle", "age": 100},
        {"name": "bob", "age": 200}
    ]

    ret = list_to_dict(list, lambda item: item['age'])
    print(ret)
