# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python 字典推导式
# 描述：Python 独步天下的推导式表达式，使用字典推导式过滤，打印非windows系统的 Python 安装介绍


def test():
    install = {
        "w": {
            "platform": "Window",
            "desc": "请下载 Windows 安装包安装：https://www.python.org/downloads/windows/"
        },
        "l": {
            "platform": "Linux",
            "desc": "请下载 Linux 的 Python 源码安装：https://www.python.org/downloads/source/",
        },
        "m": {
            "platform": "MacOS",
            "desc": "请下载 Mac 的安装包：https://www.python.org/downloads/macos/，或者使用 brew install python 安装",
        }
    }

    non_windows = {key: install[key] for key in install if key != 'w'}
    print("打算最近只用非Windows系统安装Python了:")
    print()
    for key in non_windows:
        target = non_windows[key]
        print("安装平台：{}".format(target['platform']))
        print("安装说明：{}".format(target['desc']))
        print()


if __name__ == '__main__':
    test()
