# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python 类的基本使用(1)
# 描述：编写一个kv容器类，支持 set/get/exist/keys/count 接口

class KeyValueSet:
    def __init__(self) -> None:
        self.dict = {}

    def set(self, key, value):
        self.dict[key] = value

    def get(self, key):
        return self.dict.get(key)

    def exist(self, key):
        return self.dict.get(key) is not None

    def keys(self):
        return self.dict.keys()

    def count(self):
        return len(self.dict.keys())


def test():
    kv = KeyValueSet()
    kv.set('hello', 'world!')
    kv.set('monkey', 'king!')
    kv.set('tomorrow', 'is another day')
    kv.set('good', 'bye!')

    for key in kv.keys():
        ret = input("猜一猜下半句是什么？ {} -> :".format(key))
        value = kv.get(key)
        if ret == value:
            print('你太厉害了，这都能猜得到！')
        else:
            print('哈哈，肯定猜不到得啦：{}->{}'.format(key, value))


if __name__ == '__main__':
    test()
