# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python 类的基本使用(2)
# 描述：继承容器类，扩展功能，支持类似redis的 hset/hget/hkeys 扩展接口

from key_value_set import KeyValueSet


class HashKeyValueSet(KeyValueSet):
    def __init__(self) -> None:
        super().__init__()

    def hset(self, hash_key, key, value):
        hash_set = self.get(hash_key)
        if hash_set is None:
            hash_set = {}
            hash_set[key] = value
            self.set(hash_key, hash_set)
        else:
            hash_set[key] = value
            self.set(hash_key, hash_set)

    def hget(self, hash_key, key):
        hash_set = self.get(hash_key)
        if hash_set is None:
            return None
        else:
            return hash_set.get(key)

    def hkeys(self, hash_key):
        hash_set = self.get(hash_key)
        if hash_set is None:
            return []
        else:
            return hash_set.keys()


def test():
    hashset = HashKeyValueSet()

    hashset.hset('puzzle', 'hello', 'world!')
    hashset.hset('puzzle', 'monkey', 'king!')
    hashset.hset('puzzle', 'tomorrow', 'is another day')
    hashset.hset('puzzle', 'good', 'bye!')

    keys = hashset.hkeys('puzzle')
    for key in keys:
        ret = input("猜一猜下半句是什么？ {} -> :".format(key))
        value = hashset.hget('puzzle', key)
        if ret == value:
            print('你太厉害了，这都能猜得到！')
        else:
            print('哈哈，肯定猜不到得啦：{}->{}'.format(key, value))


if __name__ == '__main__':
    test()
