# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python 编码规范
# 描述：输出MarkDown风格列表结构的 “学习 Python 编码规范以及相关工具和插件” 的介绍信息

def dump_markdown_list(tree, depth):
    for node in tree:
        if type(node) == type(''):
            print('{}* {}'.format('  '*depth, node))
        else:
            print('')
            dump_markdown_list(node, depth+1)
            print('')


if __name__ == '__main__':
    dump_markdown_list([
        'Python 编码风格',
        [
            '请阅读 Google Python 编码风格指南：',
            '[google-python-styleguide_zh_cn](https://zh-google-styleguide.readthedocs.io/en/latest/google-python-styleguide/python_style_rules /)'
        ],
        '代码风格和自动完成工具链',
        [
            '推荐使用 VSCode 开发',
            '请安装 VSCode 插件',
            [
                'Pylance',
                'Python Path',
                '请安装 pylint',
            ]
        ]
    ], 0)
