# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：面向对象
# 描述：使用 Python Class 组织代码，输出“猴子在苹果树下打架”

class Monkey(object):
    def __init__(self) -> None:
        super().__init__()
        self.tokens = []

    def add_action_token(self, token):
        self.tokens.append({"key": token})

    def play(self):
        result = []
        for token in self.tokens:
            result.append(token["key"])
        print("".join(result))


def main():
    m = Monkey()
    m.add_action_token("猴子在")
    m.add_action_token("苹果树下")
    m.add_action_token("打架")
    m.play()


if __name__ == '__main__':
    main()
