# 正则表达式实战(1)

去除html标签

```python
# -*- coding: UTF-8 -*-
import re
from typing import Text

def remove_html(content):
    # TODO(You): 请在此实现代码
    return result

if __name__ == '__main__':
    html = '''
        <html>
            <head>
                <title>这是一个简单的测试页面</title>
            </head>
            <body>
                <p class="item-0">body 元素的内容会显示在浏览器中。</p>
                <p class="item-1">title 元素的内容会显示在浏览器的标题栏中。</p>
            </body>
        </html>
        '''
    Text = remove_html(html)
    print(Text)
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import re
from typing import Text


def remove_html(content):
    pattern = re.compile(r'<[^>]+>', re.S)
    result = pattern.sub('', content)
    return result


def test():
    html = '''
        <html>
            <head>
                <title>这是一个简单的测试页面</title>
            </head>
            <body>
                <p class="item-0">body 元素的内容会显示在浏览器中。</p>
                <p class="item-1">title 元素的内容会显示在浏览器的标题栏中。</p>
            </body>
        </html>
        '''
    Text = remove_html(html)
    print(Text)

if __name__ == '__main__':
    test()
```

## 答案

```python
def remove_html(content):
    pattern = re.compile(r'<[^>]+>', re.S)
    result = pattern.sub('', content)
    return result
```

## 选项

### A

```python
def remove_html(content):
    pattern = re.compile(r'<[^>]+>')
    result = pattern.sub('', content)
    return result
```

### B

```python
def remove_html(content):
    pattern = re.compile(r'<[^>]+>', re.s)
    result = pattern.sub('', content)
    return result
```

### C

```python
def remove_html(content):
    pattern = re.compile(r'<[^>]+>', re.S)
    result = re.sub(pattern, content)
    return result
```
