# Python 命令行解析

手工编写 Python 命令行解析，支持 '-x' 或者 '--x' 类型选项处理，如果没有指定值则设置为True

```python
# -*- coding: UTF-8 -*-
import sys

def error(info):
    print(info)
    sys.exit(0)

def parse_option(token):
    if len(token) == 0 or len(token) == 1 or token[0] != '-':
        error("格式错误，选项长度至少大于2并且第一个字符必须是 '-'")

    if token[1] != '-':
        return token[1:]

    if len(token) == 2 or token[2] == '-':
        error("格式错误，不支持空选项 '--' 或则三横杆选项 '---x' ")

    return token[2:]

def parse_value(token):
    if token is None:
        return True

    if len(token) == 0:
        return True

    if token[0] == '-':
        error('格式错误')
    else:
        return token

if __name__ == '__main__':
    count = len(sys.argv)
    options = {}
    
    # TODO(You): 请在此使用 parse_option 和 parse_value 解析命令行

    for option in options:
        value = options[option]
        print("{}={}".format(option, value))
```

请选出下列能**正确**实现这一功能的选项。

## template

```python

import sys

def error(info):
    print(info)
    sys.exit(0)

def parse_option(token):
    if len(token) == 0 or len(token) == 1 or token[0] != '-':
        error("格式错误，选项长度至少大于2并且第一个字符必须是 '-'")

    if token[1] != '-':
        return token[1:]

    if len(token) == 2 or token[2] == '-':
        error("格式错误，不支持空选项 '--' 或则三横杆选项 '---x' ")

    return token[2:]


def parse_value(token):
    if token is None:
        return True

    if len(token) == 0:
        return True

    if token[0] == '-':
        error('格式错误')
    else:
        return token


if __name__ == '__main__':
    count = len(sys.argv)
    options = {}
    i = 1
    while i < count:
        token = sys.argv[i]
        next_token = None
        if i+1 < count:
            next_token = sys.argv[i+1]
            i = i + 1
        option = parse_option(token)
        value = parse_value(next_token)
        options[option] = value
        i += 1
    for option in options:
        value = options[option]
        print("{}={}".format(option, value))
```

## 答案

```python
i = 1
while i < count:
    token = sys.argv[i]
    next_token = None
    if i+1 < count:
        next_token = sys.argv[i+1]
        i = i + 1

    option = parse_option(token)
    value = parse_value(next_token)

    options[option] = value
    i += 1
```

## 选项

### A

```python
i = 1
while i < count:
    token = sys.argv[i]
    next_token = None
    if i+1 < count:
        next_token = sys.argv[i+1]

    option = parse_option(token)
    value = parse_value(next_token)

    options[option] = value
    i += 1
```

### B

```python
i = 1
while i < count:
    token = sys.argv[i]
    next_token = None
    if i+1 < count:
        next_token = sys.argv[i+1]
        i = i + 1

    option = parse_option(token)
    value = parse_value(next_token)

    options[option] = value
```

### C

```python
i = 1
while i < count:
    token = sys.argv[i]
    next_token = None
    if i+1 < count:
        next_token = sys.argv[i+1]

    option = parse_value(token)
    value = parse_option(next_token)

    options[option] = value
    i += 1
```
