# Python 字符串方法

Python 的字符串处理, 一个朴实无华的四则运算计算器，批量计算小学生四则运算表达式

```python
# -*- coding: UTF-8 -*-
import re

def naive_calc(code):
    # TODO(You): 请在此实现简易四则运算

def test():
    code = '''
    1+2
    3+4
    5-3
    4*3
    10/2
    '''
    naive_calc(code)

if __name__ == '__main__':
    test()
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import re

def naive_calc(code):
    code_lines = [l for l in code.split('\n') if l.strip() != '']

    for line in code_lines:

        ret = re.match("\s*(\d+)([\+\-\*\/])(\d+)\s*", line)
        left = ret.group(1)
        op = ret.group(2)
        right = ret.group(3)
        if op == '+':
            print('{}+{}={}'.format(left, right, int(left)+int(right)))
        elif op == '-':
            print('{}-{}={}'.format(left, right, int(left)-int(right)))
        elif op == '*':
            print('{}*{}={}'.format(left, right, int(left)*int(right)))
        elif op == '/' and right != '0':
            print('{}/{}={}'.format(left, right, int(left)/int(right)))


def test():
    code = '''
    1+2
    3+4
    5-3
    4*3
    10/2
    '''
    naive_calc(code)

if __name__ == '__main__':
    test()
```

## 答案

```python
def naive_calc(code):
    code_lines = [l for l in code.split('\n') if l.strip() != '']
    for line in code_lines:
        ret = re.match("\s*(\d+)([\+\-\*\/])(\d+)\s*", line)
        left = ret.group(1)
        op = ret.group(2)
        right = ret.group(3)
        if op == '+':
            print('{}+{}={}'.format(left, right, int(left)+int(right)))
        elif op == '-':
            print('{}-{}={}'.format(left, right, int(left)-int(right)))
        elif op == '*':
            print('{}*{}={}'.format(left, right, int(left)*int(right)))
        elif op == '/' and right != '0':
            print('{}/{}={}'.format(left, right, int(left)/int(right)))
```

## 选项

### A

```python
def naive_calc(code):
    code_lines = [l for l in code.split() if l.strip() == '']
    for line in code_lines:
        ret = re.match("\s*(\d+)([\+\-\*\/])(\d+)\s*", line)
        left = ret.group(1)
        op = ret.group(2)
        right = ret.group(3)
        
        if op == '+':
            print('{}+{}={}'.format(left, right, int(left)+int(right)))
        elif op == '-':
            print('{}-{}={}'.format(left, right, int(left)-int(right)))
        elif op == '*':
            print('{}*{}={}'.format(left, right, int(left)*int(right)))
        elif op == '/' and right != '0':
            print('{}/{}={}'.format(left, right, int(left)/int(right)))
```

### B

```python
def naive_calc(code):
    code_lines = [l for l in code.split('\n') if l.strip() != '']
    for line in code_lines:
        ret = re.match("\s*(\d+)([\+\-\*\/])(\d+)\s*", line)
        left = ret.group(1)
        op = ret.group(2)
        right = ret.group(3)

        if op == '+':
            print('{}+{}={}'.format(left, right, left+right))
        elif op == '-':
            print('{}-{}={}'.format(left, right, left-right))
        elif op == '*':
            print('{}*{}={}'.format(left, right, left*right))
        elif op == '/' and right != '0':
            print('{}/{}={}'.format(left, right, left/right))
```

### C

```python
def naive_calc(code):
    code_lines = [l for l in code.split('\n') if l.strip() != '']
    for line in code_lines:
        ret = re.match(line, "\s*(\d+)([\+\-\*\/])(\d+)\s*")
        left = ret.group(1)
        op = ret.group(2)
        right = ret.group(3)

        if op == '+':
            print('{}+{}={}'.format(left, right, left+right))
        elif op == '-':
            print('{}-{}={}'.format(left, right, left-right))
        elif op == '*':
            print('{}*{}={}'.format(left, right, left*right))
        elif op == '/' and right != '0':
            print('{}/{}={}'.format(left, right, left/right))
```
