# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python 运行方式
# 描述：提示用户选择想要了解的Python 的两种运行方式，选择后输出对应方式的基本说明，最后输出用户学习了几种运行方式

if __name__ == '__main__':
    run = {
        "repl": {
            "title": "交互式编程( Interactive )",
            "desc": [
                "打开终端，输入 python 回车",
                "进入 Python 交互式命令行",
                "输入 print('monkey king is coding!')"
            ]
        },
        "source": {
            "title": "Python 源代源文件( File )",
            "desc": [
                "使用你喜欢的编辑器拷贝本练习的代码, 保存为run.py",
                "打开终端，cd 到 run.py 保存的目录",
                "输入 python run.py"
            ]
        }
    }

    print("有两种基本的方式运行 Python")
    shoutcut_keys = {}
    for name in run:
        key = name[0].lower()
        shoutcut_keys[key] = name
        item = run.get(name)
        print("* {}: {}".format(name, item['title']))

    has_learn_repl = False
    has_learn_source = False

    while True:
        ret = input("请选择你想了解的 Python 运行方式(输入：r/s选择，输入 q 退出)：")
        if ret == 'q':
            break
        elif ret == 'r':
            has_learn_repl = True
        elif ret == 's':
            has_learn_source = True

        name = shoutcut_keys.get(ret)
        if name is None:
            print("[错误] 不支持的运行方式")
        else:
            item = run.get(name)
            desc = item['desc']
            for i in range(0, len(desc)):
                print("{}. {}".format(i, desc[i]))

    if has_learn_repl and has_learn_source:
        print("[2/2]您已完成两种 Python 运行方式的学习")
    elif has_learn_source:
        print("[1/2]您已完成 Python 源代码方式运行学习")
    elif has_learn_repl:
        print("[1/2]您已完成 Python 交互式命令行运行学习")
    else:
        print("[0/2]您似乎跳过了运行方式的学习？期待下次光临！")
