# autoscraper示例

使用 autoscraper 从stackoverflow搜索页提取相似的主题帖，代码如下：

```python
# -*- coding: UTF-8 -*-
from autoscraper import AutoScraper

def get_similar_result(url, wanted_list):
    scraper = AutoScraper()
    # TODO(You): 正确的提取代码
    return result

url = 'https://stackoverflow.com/search?q=autoscraper&s=7b5866da-920e-4926-8c33-09fb7d32886b'
wanted_list = ["AutoScraper module not found in Python Autoscraper library"]
print(get_similar_result(url, wanted_list))

```

关于缺失代码部分，以下选项<span style="color:red">正确</span>的是：

## 答案

```python
result = scraper.build(url, wanted_list)
```

## 选项

### A

```python
result = scraper.get_result_similar(url, wanted_list)
```

### B

```python
result = scraper.get(url, wanted_list)
```

### C

```python
result = scraper.get_result_exact(url, wanted_list)
```
