# Python 时间加法

从2008年1月开始到本月，遍历每一个月份的1号，并打印信息

```python
# -*- coding: UTF-8 -*-
from datetime import date, timedelta
from calendar import monthrange

def next_month(d):
    # TODO(You): 请在此实现计算下一个月的代码
    return value

def for_each_month(start, finish, action):
    while start < finish:
        action(start)
        start = next_month(start)

if __name__ == '__main__':
    for_each_month(
        date(2008, 1, 1),
        date.today(),
        lambda d: print(d)
    )
```

请选出以下实现 **错误** 的代码。

## template

```python
from datetime import date, timedelta
import calendar

def next_month(d):
    return d+timedelta(calendar.monthrange(d.year, d.month)[1])

def for_each_month(start, finish, action):
    while start < finish:
        action(start)
        start = next_month(start)


def test():
    for_each_month(
        date(2008, 1, 1),
        date.today(),
        lambda d: print(d)
    )

if __name__ == '__main__':
    test()
```

## 答案

```python
offset = monthrange(d.year, d.month)
days_in_month, first_weeky_day = offset
value = d+timedelta(days_in_month)
```

## 选项

### A

```python
offset = monthrange(d.year, d.month)
first_weeky_day, days_in_month = offset
value = d+timedelta(days_in_month)
```

### B

```python
days_in_month = monthrange(d.year, d.month)[1]
value = d+timedelta(days_in_month)
```

### C

```python
offset = monthrange(d.year, d.month)
days_in_month = offset[1]
value = d+timedelta(days_in_month)
```
