# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python Matplot 曲线绘制1
# 描述：10次进行割角细分，得到Bezier曲线

import bezier
import numpy as np
import matplotlib.pyplot as plt


def subdivision(nodes, depth, limit):
    if depth >= limit:
        return
    curve = bezier.Curve(nodes, degree=2)
    left, right = curve.subdivide()
    plt.plot(left.nodes[0], left.nodes[1])
    plt.plot(right.nodes[0], right.nodes[1])
    subdivision(left.nodes, depth+1, limit)
    subdivision(right.nodes, depth+1, limit)


if __name__ == '__main__':
    nodes = np.asfortranarray([
        [0.0, 1.25, 2.0],
        [0.0, 3.0, 1.0],
    ])
    plt.plot(nodes[0], nodes[1])
    subdivision(nodes, 0, 10)
    plt.show()
