# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：pandas 创建dataframe
# 描述：创建dataframe的几种方式

import pandas as pd
import numpy as np


def create_dataframe(measure):
    if measure == 1:
        print('由数组list组成的字典创建dataframe:')
        data = {
            'cloumn_one': np.random.randint(0, 10, size=5),
            'cloumn_two': np.random.randint(0, 10, size=5),
            'cloumn_three': np.random.randint(0, 10, size=5)
        }
        data_df = pd.DataFrame(data)
        print(data_df)

    elif measure == 2:
        print('由Series组成的字典创建dataframe:')
        data = {
            'cloumn_one': pd.Series(np.random.randint(0, 10, size=5)),
            'cloumn_two': pd.Series(np.random.randint(0, 10, size=5)),
            'cloumn_three': pd.Series(np.random.randint(0, 10, size=5))
        }
        data_df = pd.DataFrame(data)
        print(data_df)
    elif measure == 3:
        print('通过二维数组直接创建dataframe:')
        data = np.random.randint(0, 10, size=9).reshape(3, 3)
        data_df = pd.DataFrame(
            data, columns=['cloumn_one', 'cloumn_two', 'cloumn_three'])
        print(data_df)
    elif measure == 4:
        print('由字典组成的列表创建dataframe:')
        data = [{'cloumn_one': 1, 'cloumn_two': 2, 'cloumn_three': 3},
                {'cloumn_one': 5, 'cloumn_two': 6, 'cloumn_three': 7}]
        data_df = pd.DataFrame(data)
        print(data_df)
    else:
        print('该参数不支持，可选参数为1，2，3，4')


if __name__ == '__main__':
    create_dataframe(1)
    create_dataframe(2)
    create_dataframe(3)
    create_dataframe(4)
    create_dataframe(0)
