# Python WxPython 例子

使用 WxPython 创建窗口、菜单、添加关闭事件，请完成功能：

1. 创建一个菜单栏
2. 在菜单栏里添加一列菜单，并提添加一个关闭条目
3. 绑定关闭条目的关闭事件

```python
# -*- coding: UTF-8 -*-
# create_window.py
import wx

class BasicFrame(wx.Frame):
    def __init__(self, title, pos, size):
        wx.Frame.__init__(self, None, title=title,
                          pos=pos, size=size)
        self.init_close_event()
        self.init_menu_bar()
        self.init_status_bar()

    def init_close_event(self):
        # 绑定关闭事件
        self.Bind(wx.EVT_CLOSE, self.OnClose)

    def init_menu_bar(self):
        # TODO(You): 请在此实现添加菜单逻辑

    def init_status_bar(self):
        # 创建一个状态栏
        self.statusbar = self.CreateStatusBar()

    def OnClose(self, event):
        # 创建确认关闭对话框
        dlg = wx.MessageDialog(
            self,
            "Do you really want to close this application?",
            "Confirm Exit", wx.OK | wx.CANCEL | wx.ICON_QUESTION
        )

        # 显示对话框
        result = dlg.ShowModal()

        # 销毁对话框
        dlg.Destroy()
        if result == wx.ID_OK:
            # 销毁窗口
            self.Destroy()

if __name__ == '__main__':
    app = wx.App(redirect=True)
    top = BasicFrame(
        title="Hello World",
        pos=(150, 150),
        size=(350, 200)
    )
    top.Show()
    app.MainLoop()
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import wx


class BasicFrame(wx.Frame):
    def __init__(self, title, pos, size):
        wx.Frame.__init__(self, None, title=title,
                          pos=pos, size=size)
        self.init_close_event()
        self.init_menu_bar()
        self.init_status_bar()

    def init_close_event(self):
        self.Bind(wx.EVT_CLOSE, self.OnClose)

    def init_menu_bar(self):
        menuBar = wx.MenuBar()
        menu = wx.Menu()
        m_exit = menu.Append(
            wx.ID_EXIT,
            "E&xit\tAlt-X",
            "Close window and exit program."
        )
        self.Bind(wx.EVT_MENU, self.OnClose, m_exit)
        self.SetMenuBar(menuBar)

    def init_status_bar(self):
        self.statusbar = self.CreateStatusBar()

    def OnClose(self, event):
        dlg = wx.MessageDialog(
            self,
            "Do you really want to close this application?",
            "Confirm Exit", wx.OK | wx.CANCEL | wx.ICON_QUESTION
        )
        result = dlg.ShowModal()
        dlg.Destroy()
        if result == wx.ID_OK:
            self.Destroy()

if __name__ == '__main__':
    app = wx.App(redirect=True)
    top = BasicFrame(
        title="Hello World",
        pos=(150, 150),
        size=(350, 200)
    )
    top.Show()
    app.MainLoop()
```

## 答案

```python
class BasicFrame(wx.Frame):
    ...
    def init_menu_bar(self):
        menuBar = wx.MenuBar()
        menu = wx.Menu()
        m_exit = menu.Append(
            wx.ID_EXIT,
            "E&xit\tAlt-X",
            "Close window and exit program."
        )
        self.Bind(wx.EVT_MENU, self.OnClose, m_exit)
        self.SetMenuBar(menuBar)
```

## 选项

### A

```python
class BasicFrame(wx.Frame):
    ...
    def init_menu_bar(self):
        menuBar = wx.MenuBar()
        m_exit = menuBar.Append(
            wx.ID_EXIT,
            "E&xit\tAlt-X",
            "Close window and exit program."
        )
        self.Bind(wx.EVT_MENU, self.OnClose, m_exit)
```

### B

```python
class BasicFrame(wx.Frame):
    ...
    def init_menu_bar(self):
        menuBar = wx.MenuBar()
        menu = wx.Menu()
        m_exit = menu.Append(
            "E&xit\tAlt-X",
            "Close window and exit program."
        )
        self.Bind(wx.EVT_MENU, self.OnClose, m_exit)
        self.SetMenuBar(menuBar)
```

### C

```python
class BasicFrame(wx.Frame):
    ...
    def init_menu_bar(self):
        menuBar = wx.MenuBar()
        m_exit = menuBar.Append(
            wx.ID_EXIT,
            "E&xit\tAlt-X",
            "Close window and exit program."
        )
        self.Bind(wx.EVT_MENU, m_exit)
```
